* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Compute firm-level value-added weights
bys year: egen VA_tot 	= total(value_added)
sort id year
gen va_share 		= value_added / VA_tot
drop VA_tot

* Compute value-added weighted dispersion of APK, TFP, and reallocation rates
local disp_vars TFP APK RK
qui levelsof year, local(years)
foreach v of local disp_vars{
	qui gen sd_`v' 	= .
	* qui gen iqr_`v' 	= .

	foreach t of local years {	
		* Value-added weights
		qui su `v' [w=va_share] 				if 	year == `t', d
		qui replace sd_`v' 		= r(sd) 		if 	year == `t' 	
	}
} 


**********************************************************************
**********************************************************************

* Label key variables
lab var sd_TFP "std TFP, va-weighted"
lab var sd_APK "std APK, va-weighted"
lab var sd_RK  "std R/K, va-weighted"
